'use strict';

/* --------------------------------------------------------------
 product_related_actions_controller.js 2015-10-15 gm
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Related Actions Controller
 *
 * This controller contains the mapping logic of the products properties/attributes/special buttons.
 *
 * @module Controllers/product_related_actions_controller
 */
gx.controllers.module('product_related_actions_controller', [gx.source + '/libs/button_dropdown'],

/** @lends module:Controllers/product_related_actions_controller */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @var {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {
        'properties_url': '',
        'attributes_url': '',
        'specials_url': '',
        'product_id': '',
        'c_path': '',
        'recent_button': 'BUTTON_SPECIAL'
    },


    /**
     * Final Options
     *
     * @var {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // PRIVATE METHODS
    // ------------------------------------------------------------------------

    /**
     * Map actions to buttons.
     *
     * @private
     */
    var _setActions = function _setActions() {
        var actions = [];

        actions.BUTTON_SPECIAL = _setSpecialPriceActionCallback;
        actions.BUTTON_PROPERTIES = _setPropertiesActionCallback;
        actions.BUTTON_ATTRIBUTES = _setAttributesActionCallback;

        if (options.attributes_url === '' && options.recent_button === 'BUTTON_ATTRIBUTES') {
            options.recent_button = defaults.recent_button;
        }

        jse.libs.button_dropdown.mapAction($this, 'BUTTON_SPECIAL', 'admin_buttons', _setSpecialPriceActionCallback);
        jse.libs.button_dropdown.mapAction($this, 'BUTTON_PROPERTIES', 'admin_buttons', _setPropertiesActionCallback);

        if (options.attributes_url !== '') {
            jse.libs.button_dropdown.mapAction($this, 'BUTTON_ATTRIBUTES', 'admin_buttons', _setAttributesActionCallback);
        }
    };

    /**
     * Redirect to special pricing page.
     *
     * @returns {boolean}
     *
     * @private
     */
    var _setSpecialPriceActionCallback = function _setSpecialPriceActionCallback() {

        if (options.specials_url !== '') {
            window.location.href = options.specials_url;

            return true;
        }

        return false;
    };

    /**
     * Redirect to properties page.
     *
     * @returns {boolean}
     * @private
     */
    var _setPropertiesActionCallback = function _setPropertiesActionCallback() {

        if (options.properties_url !== '') {
            window.location.href = options.properties_url;

            return true;
        }

        return false;
    };

    /**
     * Redirect to attributes page.
     *
     * @returns {boolean}
     *
     * @private
     */
    var _setAttributesActionCallback = function _setAttributesActionCallback() {

        if (options.attributes_url !== '' && options.product_id !== '') {
            var $form = $('<form action="' + options.attributes_url + '" method="post">' + '<input type="hidden" name="action" value="edit" />' + '<input type="hidden" name="current_product_id" value="' + options.product_id + '" />' + '<input type="hidden" name="cpath" value="' + options.c_path + '" />' + '</form>');

            $('body').prepend($form);

            $form.submit();

            return true;
        }

        return false;
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        window.setTimeout(_setActions, 300);
        done(); // Finish it
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
